/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package Chapter11.map;

import java.time.*;
import static java.time.Month.*;
import static java.time.temporal.ChronoUnit.HOURS;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Matthew Gregory
 */
public class StartHere {

    public static void main(String[] args) {

        DataSource myData = new DataSource();
        Person me = myData.people[0];
        Person myCustomer = myData.people[1];
        Person myColleague = myData.people[2];
        Meeting myMeeting = myData.meetings[0];
        Meeting initialMeeting = myData.meetings[1];
        Meeting internalMeeting = myData.meetings[2];
        Meeting followupMeeting = myData.meetings[3];
        Collections.addAll(initialMeeting.agendaItems,"Introductions.","Needs Analysis","Closure");
        Collections.addAll(internalMeeting.agendaItems,"Discuss Needs Analysis","Propose Design","Calculate Proposed Budget");
        Collections.addAll(followupMeeting.agendaItems,"Introductions.","Suggest Design","Provide Quote","Further Questions");

        //Assign dates to the meetings
        initialMeeting.meetingDate = LocalDateTime.of(2020, MARCH, 20, 10, 00).atZone(me.timezone);
        internalMeeting.meetingDate = LocalDateTime.of(2020, MARCH, 27, 14, 00).atZone(me.timezone);
        followupMeeting.meetingDate = LocalDateTime.of(2020, APRIL, 5, 9, 00).atZone(me.timezone);
        
        //Check to make sure everything is setup okay.
//        System.out.println(initialMeeting);
//        System.out.println(internalMeeting);
//        System.out.println(followupMeeting);
        
        //Create a list of meetings using the Map collection
        Map<LocalDate,Meeting> mySchedule = new HashMap<>();
        //Add meetings to the schedule.
        mySchedule.put(initialMeeting.meetingDate.toLocalDate(),initialMeeting);
        mySchedule.put(internalMeeting.meetingDate.toLocalDate(),internalMeeting);
        mySchedule.put(followupMeeting.meetingDate.toLocalDate(),followupMeeting);
        //Print my Shedule
        System.out.println("Schedule: "+mySchedule);
        //Print my meetings
        System.out.println("Meetings: "+mySchedule.values());
        //Print my dates
        System.out.println("Dates: "+mySchedule.keySet());
        //Get the meeting on a given date
        LocalDate searchDate = LocalDate.of(2020,APRIL,5);
        System.out.println("Meetings on "+searchDate+"; "+mySchedule.get(searchDate));
        
        //You can not add values that share the same key.
        //create meeting.
        Meeting debrief = new Meeting(me,myColleague);
        debrief.meetingDate = searchDate.atTime(11, 00).atZone(me.timezone);
        //Add meeting to Schedule
        mySchedule.put(searchDate, debrief);
        System.out.println("Meetings on "+searchDate+"; "+mySchedule.get(searchDate));
        }
}
